/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.operation.NumericConverter;

public enum SignOperator {
    NONE(""){

        @Override
        public Value operate(Number value) {
            NumericConverter converter = NumericConverter.resolveConverter(value);
            Double decimal = value.doubleValue();
            return converter.convert(decimal);
        }
    }
    ,
    PLUS("+"){

        @Override
        public Value operate(Number value) {
            NumericConverter converter = NumericConverter.resolveConverter(value);
            Double decimal = value.doubleValue();
            return converter.convert((double)decimal);
        }
    }
    ,
    MINUS("-"){

        @Override
        public Value operate(Number value) {
            NumericConverter converter = NumericConverter.resolveConverter(value);
            Double decimal = value.doubleValue();
            return converter.convert(-decimal.doubleValue());
        }
    };

    public final String operator;

    private SignOperator(String operator) {
        this.operator = operator;
    }

    public abstract Value operate(Number var1);

    public static SignOperator resolveOperator(StringToken token) {
        if (token != null) {
            SignOperator[] operators;
            String value = token.getValue();
            for (SignOperator operator : operators = SignOperator.values()) {
                if (!operator.operator.equals(value)) continue;
                return operator;
            }
        }
        return NONE;
    }
}

