/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.template;

import java.io.Writer;
import org.snapscript.core.Context;
import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.convert.StringBuilder;
import org.snapscript.tree.template.Segment;

public class ExpressionSegment
implements Segment {
    private String expression;
    private char[] source;
    private int off;
    private int length;

    public ExpressionSegment(char[] source, int off, int length) {
        this.expression = new String(source, off + 2, length - 3);
        this.source = source;
        this.length = length;
        this.off = off;
    }

    @Override
    public void process(Scope scope, Writer writer) throws Exception {
        Module module = scope.getModule();
        String name = module.getName();
        Context context = module.getContext();
        ExpressionEvaluator evaluator = context.getEvaluator();
        Object value = evaluator.evaluate(scope, this.expression, name);
        if (value == null) {
            writer.write(this.source, this.off, this.length);
        } else {
            String text = StringBuilder.create(scope, value);
            writer.append(text);
        }
    }

    public String toString() {
        return this.expression;
    }
}

