/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.Evaluation;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Scope;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.template.Segment;
import org.snapscript.tree.template.SegmentIterator;

public class TextTemplate
implements Evaluation {
    private volatile List<Segment> tokens = new ArrayList<Segment>();
    private volatile StringToken template;

    public TextTemplate(StringToken template) {
        this.template = template;
    }

    @Override
    public Value evaluate(Scope scope, Object left) throws Exception {
        String text = this.template.getValue();
        if (text == null) {
            throw new InternalStateException("Text value was null");
        }
        String result = this.interpolate(scope, text);
        return ValueType.getTransient(result);
    }

    private String interpolate(Scope scope, String text) throws Exception {
        StringWriter writer = new StringWriter();
        if (this.tokens.isEmpty()) {
            SegmentIterator iterator = new SegmentIterator(text);
            ArrayList<Segment> list = new ArrayList<Segment>();
            while (iterator.hasNext()) {
                Segment token = iterator.next();
                if (token == null) continue;
                list.add(token);
            }
            this.tokens = list;
        }
        for (Segment token : this.tokens) {
            token.process(scope, writer);
        }
        return writer.toString();
    }
}

