/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.template;

import java.io.Writer;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Value;
import org.snapscript.core.convert.StringBuilder;
import org.snapscript.tree.template.Segment;

public class VariableSegment
implements Segment {
    private String variable;
    private char[] source;
    private int off;
    private int length;

    public VariableSegment(char[] source, int off, int length) {
        this.variable = new String(source, off + 2, length - 3);
        this.source = source;
        this.length = length;
        this.off = off;
    }

    @Override
    public void process(Scope scope, Writer writer) throws Exception {
        State state = scope.getState();
        Value value = state.get(this.variable);
        if (value == null) {
            writer.write(this.source, this.off, this.length);
        } else {
            Object token = value.getValue();
            String text = StringBuilder.create(scope, token);
            writer.append(text);
        }
    }

    public String toString() {
        return this.variable;
    }
}

