/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.variable;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.property.MapProperty;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;
import org.snapscript.tree.variable.ObjectPointer;
import org.snapscript.tree.variable.VariablePointer;

public class MapPointer
implements VariablePointer<Map> {
    private final AtomicReference<Property> reference = new AtomicReference();
    private final ObjectPointer pointer;
    private final String name;

    public MapPointer(String name) {
        this.pointer = new ObjectPointer(name);
        this.name = name;
    }

    @Override
    public Value get(Scope scope, Map left) {
        Property accessor = this.reference.get();
        if (accessor == null) {
            Property match = this.match(scope, left);
            if (match != null) {
                this.reference.set(match);
                return new PropertyValue(match, left, this.name);
            }
            return null;
        }
        return new PropertyValue(accessor, left, this.name);
    }

    public Property match(Scope scope, Object left) {
        Property property = this.pointer.match(scope, left);
        if (property == null) {
            Module module = scope.getModule();
            Class<?> type = left.getClass();
            String alias = type.getName();
            Type source = module.getType(alias);
            return new MapProperty(this.name, source, ModifierType.PUBLIC.mask);
        }
        return property;
    }
}

