/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.variable;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;
import org.snapscript.tree.variable.ObjectPointer;
import org.snapscript.tree.variable.VariablePointer;

public class ModulePointer
implements VariablePointer<Module> {
    private final AtomicReference<Property> reference = new AtomicReference();
    private final ObjectPointer pointer;
    private final String name;

    public ModulePointer(String name) {
        this.pointer = new ObjectPointer(name);
        this.name = name;
    }

    @Override
    public Value get(Scope scope, Module left) {
        Property property = this.reference.get();
        if (property == null) {
            Scope inner = left.getScope();
            State state = inner.getState();
            Value value = state.get(this.name);
            if (value == null) {
                Type type = left.getType(this.name);
                if (type != null) {
                    return ValueType.getTransient(type);
                }
                Property match = this.pointer.match(scope, left);
                if (match != null) {
                    this.reference.set(match);
                    return new PropertyValue(match, left, this.name);
                }
            }
            return value;
        }
        return new PropertyValue(property, left, this.name);
    }
}

