/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.variable;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.Value;
import org.snapscript.core.property.ConstantPropertyBuilder;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;
import org.snapscript.tree.variable.ModuleConstantResolver;
import org.snapscript.tree.variable.VariablePointer;

public class ObjectPointer
implements VariablePointer<Object> {
    private final AtomicReference<Property> reference = new AtomicReference();
    private final ConstantPropertyBuilder builder = new ConstantPropertyBuilder();
    private final ModuleConstantResolver resolver = new ModuleConstantResolver();
    private final String name;

    public ObjectPointer(String name) {
        this.name = name;
    }

    @Override
    public Value get(Scope scope, Object left) {
        Property accessor = this.reference.get();
        if (accessor == null) {
            Property match = this.match(scope, left);
            if (match != null) {
                this.reference.set(match);
                return new PropertyValue(match, left, this.name);
            }
            return null;
        }
        return new PropertyValue(accessor, left, this.name);
    }

    public Property match(Scope scope, Object left) {
        Class<?> type = left.getClass();
        String alias = type.getName();
        Module module = scope.getModule();
        Type source = module.getType(alias);
        if (source != null) {
            Context context = module.getContext();
            TypeExtractor extractor = context.getExtractor();
            Set<Type> list = extractor.getTypes(source);
            for (Type base : list) {
                Property match = this.match(scope, left, base);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    public Property match(Scope scope, Object left, Type type) {
        List<Property> properties = type.getProperties();
        for (Property property : properties) {
            String field = property.getName();
            if (!field.equals(this.name)) continue;
            return property;
        }
        Scope outer = type.getScope();
        Object value = this.resolver.resolve(outer, this.name);
        if (value != null) {
            return this.builder.createConstant(this.name, value);
        }
        return null;
    }
}

