/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.variable;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.Value;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;
import org.snapscript.tree.variable.VariablePointer;

public class ScopePointer
implements VariablePointer<Scope> {
    private final AtomicReference<Property> reference = new AtomicReference();
    private final String name;

    public ScopePointer(String name) {
        this.name = name;
    }

    @Override
    public Value get(Scope scope, Scope left) {
        Property property;
        Type type;
        State state = left.getState();
        Value value = state.get(this.name);
        if (value == null && (type = left.getType()) != null && (property = this.match(scope, left)) != null) {
            this.reference.set(property);
            return new PropertyValue(property, left, this.name);
        }
        return value;
    }

    private Property match(Scope scope, Scope left) {
        Property property = this.reference.get();
        if (property == null) {
            Type source = left.getType();
            Module module = scope.getModule();
            Context context = module.getContext();
            TypeExtractor extractor = context.getExtractor();
            Set<Type> list = extractor.getTypes(source);
            for (Type base : list) {
                Property match = this.match(scope, left, base);
                if (match == null) continue;
                return match;
            }
        }
        return property;
    }

    private Property match(Scope scope, Object left, Type type) {
        List<Property> properties = type.getProperties();
        for (Property property : properties) {
            String field = property.getName();
            if (!field.equals(this.name)) continue;
            return property;
        }
        return null;
    }
}

