/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.variable;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.Value;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;
import org.snapscript.tree.variable.ObjectPointer;
import org.snapscript.tree.variable.VariablePointer;

public class TypePointer
implements VariablePointer<Type> {
    private final AtomicReference<Property> reference = new AtomicReference();
    private final ObjectPointer pointer;
    private final String name;

    public TypePointer(String name) {
        this.pointer = new ObjectPointer(name);
        this.name = name;
    }

    @Override
    public Value get(Scope scope, Type left) {
        Property property = this.reference.get();
        if (property == null) {
            Module module = scope.getModule();
            Context context = module.getContext();
            TypeExtractor extractor = context.getExtractor();
            Set<Type> list = extractor.getTypes(left);
            for (Type base : list) {
                Property match = this.pointer.match(scope, left, base);
                if (match == null) continue;
                this.reference.set(match);
                return new PropertyValue(match, left, this.name);
            }
            Property match = this.pointer.match(scope, left);
            if (match != null) {
                this.reference.set(match);
                return new PropertyValue(match, left, this.name);
            }
            return null;
        }
        return new PropertyValue(property, left, this.name);
    }
}

