/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.variable;

import java.util.Collection;
import java.util.Map;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.define.Instance;
import org.snapscript.tree.variable.ArrayPointer;
import org.snapscript.tree.variable.CollectionPointer;
import org.snapscript.tree.variable.InstancePointer;
import org.snapscript.tree.variable.LocalPointer;
import org.snapscript.tree.variable.MapPointer;
import org.snapscript.tree.variable.ModulePointer;
import org.snapscript.tree.variable.ObjectPointer;
import org.snapscript.tree.variable.ScopePointer;
import org.snapscript.tree.variable.TypePointer;
import org.snapscript.tree.variable.VariableBinder;
import org.snapscript.tree.variable.VariableKeyBuilder;
import org.snapscript.tree.variable.VariablePointer;

public class VariablePointerResolver {
    private final Cache<Object, VariablePointer> cache = new CopyOnWriteCache<Object, VariablePointer>();
    private final VariableKeyBuilder builder = new VariableKeyBuilder();
    private final VariableBinder binder;

    public VariablePointerResolver(VariableBinder binder) {
        this.binder = binder;
    }

    public VariablePointer resolve(Scope scope, Object left, String name) {
        Object key = this.builder.create(scope, left, name);
        VariablePointer pointer = this.cache.fetch(key);
        if (pointer == null) {
            pointer = this.create(scope, left, name);
            this.cache.cache(key, pointer);
        }
        return pointer;
    }

    private VariablePointer create(Scope scope, Object left, String name) {
        if (left != null) {
            Class<?> type = left.getClass();
            if (Module.class.isInstance(left)) {
                return new ModulePointer(name);
            }
            if (Map.class.isInstance(left)) {
                return new MapPointer(name);
            }
            if (Scope.class.isInstance(left)) {
                return new ScopePointer(name);
            }
            if (Type.class.isInstance(left)) {
                return new TypePointer(name);
            }
            if (Collection.class.isInstance(left)) {
                return new CollectionPointer(name);
            }
            if (type.isArray()) {
                return new ArrayPointer(name);
            }
            return new ObjectPointer(name);
        }
        if (Instance.class.isInstance(scope)) {
            return new InstancePointer(name);
        }
        return new LocalPointer(name);
    }
}

