/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.snapscript.asm.ClassVisitor;
import org.snapscript.asm.Type;
import org.snapscript.cglib.core.AbstractClassGenerator;
import org.snapscript.cglib.core.ClassEmitter;
import org.snapscript.cglib.core.CodeEmitter;
import org.snapscript.cglib.core.CollectionUtils;
import org.snapscript.cglib.core.DuplicatesPredicate;
import org.snapscript.cglib.core.EmitUtils;
import org.snapscript.cglib.core.KeyFactory;
import org.snapscript.cglib.core.MethodInfo;
import org.snapscript.cglib.core.MethodInfoTransformer;
import org.snapscript.cglib.core.MethodWrapper;
import org.snapscript.cglib.core.Predicate;
import org.snapscript.cglib.core.ReflectUtils;
import org.snapscript.cglib.core.RejectModifierPredicate;
import org.snapscript.cglib.core.Signature;
import org.snapscript.cglib.core.Transformer;
import org.snapscript.cglib.core.TypeUtils;
import org.snapscript.cglib.core.VisibilityPredicate;
import org.snapscript.cglib.proxy.Enhancer;
import org.snapscript.cglib.proxy.Factory;

public class ConcreteClassGenerator
extends AbstractClassGenerator {
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(ConcreteClassGenerator.class.getName());
    private static final ConcreteClassGeneratorKey KEY_FACTORY = (ConcreteClassGeneratorKey)((Object)KeyFactory.create(ConcreteClassGeneratorKey.class));
    private Class[] interfaces;
    private Class superclass;
    private boolean classOnly;

    public ConcreteClassGenerator() {
        super(SOURCE);
    }

    public void setSuperclass(Class superclass) {
        if (superclass != null && superclass.equals(Object.class)) {
            superclass = null;
        }
        this.superclass = superclass;
    }

    public void setInterfaces(Class ... interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        return ReflectUtils.getProtectionDomain(this.superclass);
    }

    public Class createClass() {
        this.classOnly = true;
        return this.createHelper();
    }

    private Class createHelper() {
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        }
        String superName = this.superclass != null ? this.superclass.getName() : "java.lang.Object";
        Object key = KEY_FACTORY.newInstance(superName, ReflectUtils.getNames(this.interfaces));
        return (Class)super.create(key);
    }

    @Override
    public void generateClass(ClassVisitor v) throws Exception {
        Class sc;
        Class clazz = sc = this.superclass == null ? Object.class : this.superclass;
        if (TypeUtils.isFinal(sc.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + sc.getName());
        }
        ArrayList constructors = new ArrayList(Arrays.asList(sc.getDeclaredConstructors()));
        Enhancer.filterConstructors(sc, constructors);
        ArrayList actualMethods = new ArrayList();
        ArrayList interfaceMethods = new ArrayList();
        final HashSet forcePublic = new HashSet();
        ConcreteClassGenerator.getMethods(sc, this.interfaces, actualMethods, interfaceMethods, forcePublic);
        List methods = CollectionUtils.transform(actualMethods, new Transformer(){

            @Override
            public Object transform(Object value) {
                Method method = (Method)value;
                int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
                if (forcePublic.contains(MethodWrapper.create(method))) {
                    modifiers = modifiers & 0xFFFFFFFB | 1;
                }
                return ReflectUtils.getMethodInfo(method, modifiers);
            }
        });
        ClassEmitter ce = new ClassEmitter(v);
        ce.begin_class(46, 1, this.getClassName(), Type.getType(sc), TypeUtils.getTypes(this.interfaces), "<generated>");
        List constructorInfo = CollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        this.emitConstructors(ce, constructorInfo);
        for (MethodInfo methodInfo : methods) {
            CodeEmitter emitter = EmitUtils.begin_method(ce, methodInfo);
            emitter.throw_exception(Type.getType(UnsupportedOperationException.class), "Method not implemented");
            emitter.end_method();
        }
        ce.end_class();
    }

    private void emitConstructors(ClassEmitter ce, List constructors) {
        boolean seenNull = false;
        for (MethodInfo constructor : constructors) {
            CodeEmitter e = EmitUtils.begin_method(ce, constructor, 1);
            e.load_this();
            e.dup();
            e.load_args();
            Signature sig = constructor.getSignature();
            seenNull = seenNull || sig.getDescriptor().equals("()V");
            e.super_invoke_constructor(sig);
            e.return_value();
            e.end_method();
        }
    }

    public static void getMethods(Class superclass, Class[] interfaces, List methods, List interfaceMethods, Set forcePublic) {
        List target;
        ReflectUtils.addAllMethods(superclass, methods);
        List list = target = interfaceMethods != null ? interfaceMethods : methods;
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] == Factory.class) continue;
                ReflectUtils.addAllMethods(interfaces[i], target);
            }
        }
        if (interfaceMethods != null) {
            if (forcePublic != null) {
                forcePublic.addAll(MethodWrapper.createSet(interfaceMethods));
            }
            methods.addAll(interfaceMethods);
        }
        CollectionUtils.filter(methods, new RejectModifierPredicate(8));
        CollectionUtils.filter(methods, new VisibilityPredicate(superclass, true));
        CollectionUtils.filter(methods, new DuplicatesPredicate());
        CollectionUtils.filter(methods, new RejectModifierPredicate(16));
        CollectionUtils.filter(methods, new Predicate(){

            @Override
            public boolean evaluate(Object name) {
                Method method = (Method)name;
                int modifiers = method.getModifiers();
                return Modifier.isAbstract(modifiers);
            }
        });
    }

    @Override
    protected Object firstInstance(Class type) {
        if (this.classOnly) {
            return type;
        }
        return ReflectUtils.newInstance(type);
    }

    @Override
    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        return ReflectUtils.newInstance(protoclass);
    }

    static interface ConcreteClassGeneratorKey {
        public Object newInstance(String var1, String[] var2);
    }
}

