/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CompoundIterator<T>
implements Iterator<T> {
    private Iterator[] iterators;
    private Object next;
    private Set done = new HashSet();
    private int index;

    public CompoundIterator(Iterator ... iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            while (this.index < this.iterators.length) {
                Iterator iterator = this.iterators[this.index];
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    if (!this.done.add(value)) continue;
                    this.next = value;
                    return true;
                }
                ++this.index;
            }
        }
        return this.next != null;
    }

    @Override
    public T next() {
        Object local = this.next;
        if (local == null) {
            if (!this.hasNext()) {
                return null;
            }
            local = this.next;
        }
        this.next = null;
        return (T)local;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

