/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.snapscript.common.Cache;

public class CopyOnWriteCache<K, V>
implements Cache<K, V> {
    private volatile MapUpdater updater;
    private volatile Map<K, V> cache;

    public CopyOnWriteCache() {
        this(16);
    }

    public CopyOnWriteCache(int size) {
        this(16, 0.5f);
    }

    public CopyOnWriteCache(int size, float density) {
        this.updater = new MapUpdater(size, density);
        this.cache = new HashMap();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public V take(K key) {
        return this.updater.take(key);
    }

    @Override
    public V fetch(K key) {
        return this.cache.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean contains(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void cache(K key, V value) {
        this.updater.cache(key, value);
    }

    @Override
    public void clear() {
        this.updater.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    public String toString() {
        return String.valueOf(this.cache);
    }

    private class MapUpdater {
        private final Map<K, V> empty = new HashMap();
        private final float density;
        private final int size;

        public MapUpdater(int size, float density) {
            this.density = density;
            this.size = size;
        }

        public synchronized void cache(K key, V value) {
            Object existing = CopyOnWriteCache.this.cache.get(key);
            if (existing != value) {
                HashMap copy = new HashMap(this.size, this.density);
                copy.putAll(CopyOnWriteCache.this.cache);
                copy.put(key, value);
                CopyOnWriteCache.this.cache = copy;
            }
        }

        public synchronized V take(K key) {
            Object existing = CopyOnWriteCache.this.cache.get(key);
            if (existing != null) {
                HashMap copy = new HashMap(this.size, this.density);
                copy.putAll(CopyOnWriteCache.this.cache);
                copy.remove(key);
                CopyOnWriteCache.this.cache = copy;
            }
            return existing;
        }

        public synchronized void clear() {
            CopyOnWriteCache.this.cache = this.empty;
        }
    }
}

