/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.snapscript.common.Cache;

public class HashCache<K, V>
implements Cache<K, V> {
    private volatile Map<K, V> map = Collections.EMPTY_MAP;

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V take(K key) {
        return this.map.remove(key);
    }

    @Override
    public V fetch(K key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public void cache(K key, V value) {
        if (this.map == Collections.EMPTY_MAP) {
            this.map = new HashMap();
        }
        this.map.put(key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return String.valueOf(this.map);
    }
}

