/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.Set;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.common.LazyBuilder;

public class LazyCache<K, V>
implements Cache<K, V> {
    private final LazyBuilder<K, V> builder;
    private final Cache<K, V> cache;

    public LazyCache(LazyBuilder<K, V> builder) {
        this(builder, 16);
    }

    public LazyCache(LazyBuilder<K, V> builder, int size) {
        this.cache = new CopyOnWriteCache(size);
        this.builder = builder;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public V fetch(K key) {
        V value = this.cache.fetch(key);
        if (value == null) {
            value = this.builder.create(key);
            this.cache.cache(key, value);
        }
        return value;
    }

    @Override
    public void cache(K key, V value) {
        this.cache.cache(key, value);
    }

    @Override
    public V take(K key) {
        return this.cache.take(key);
    }

    @Override
    public boolean contains(K key) {
        return this.cache.contains(key);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public String toString() {
        return String.valueOf(this.cache);
    }
}

