/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.common.Progress;
import org.snapscript.common.ProgressException;

public class LockProgress<T extends Enum>
implements Progress<T> {
    private final AtomicInteger last;
    private final Object lock;

    public LockProgress() {
        this(-1);
    }

    public LockProgress(int value) {
        this.last = new AtomicInteger(value);
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean done(T phase) {
        int latest;
        int ordinal = ((Enum)phase).ordinal();
        if (ordinal > (latest = this.last.get())) {
            Object object = this.lock;
            synchronized (object) {
                int current = this.last.get();
                if (ordinal > current) {
                    this.last.set(ordinal);
                    this.lock.notifyAll();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wait(T phase) {
        int ordinal = ((Enum)phase).ordinal();
        int latest = this.last.get();
        while (ordinal > latest) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (Exception e) {
                    throw new ProgressException("Error waiting for " + phase, e);
                }
            }
            latest = this.last.get();
        }
        return ordinal <= latest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wait(T phase, long duration) {
        long time = System.currentTimeMillis();
        long expiry = Math.max(time, time + duration);
        int ordinal = ((Enum)phase).ordinal();
        int latest = this.last.get();
        while (ordinal > latest && duration > 0L) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(duration);
                }
                catch (Exception e) {
                    throw new ProgressException("Error waiting for " + phase, e);
                }
            }
            time = System.currentTimeMillis();
            duration = expiry - time;
            latest = this.last.get();
        }
        return ordinal <= latest;
    }
}

