/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

public class SparseArray<T> {
    private volatile Object[][] segments;
    private volatile int capacity;
    private volatile int block;

    public SparseArray(int length) {
        this(length, 32);
    }

    public SparseArray(int length, int block) {
        this.segments = new Object[length / block + 1][];
        this.capacity = length;
        this.block = block;
    }

    public T set(int index, T value) {
        int offset = index % this.block;
        Object[] segment = this.segment(index);
        Object result = segment[offset];
        segment[offset] = value;
        return (T)result;
    }

    public T get(int index) {
        Object[] segment;
        int section = index / this.block;
        if (section < this.segments.length && (segment = this.segments[section]) != null) {
            return (T)segment[index % this.block];
        }
        return null;
    }

    public T remove(int index) {
        Object[] segment;
        int section = index / this.block;
        if (section < this.segments.length && (segment = this.segments[section]) != null) {
            int offset = index % this.block;
            Object result = segment[offset];
            segment[offset] = null;
            return (T)result;
        }
        return null;
    }

    protected Object[] segment(int index) {
        Object[] segment;
        int section = index / this.block;
        if (index >= this.capacity) {
            this.expand(this.capacity * 2 < index ? index : this.capacity * 2);
        }
        if ((segment = this.segments[section]) == null) {
            this.segments[section] = new Object[this.block];
        }
        return this.segments[section];
    }

    protected void expand(int length) {
        Object[][] copy = new Object[length / this.block + 1][];
        for (int i = 0; i < this.segments.length; ++i) {
            copy[i] = this.segments[i];
        }
        this.capacity = length;
        this.segments = copy;
    }

    public int length() {
        return this.capacity;
    }
}

