/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.command;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import org.snapscript.common.command.CommandOperation;
import org.snapscript.common.command.Console;
import org.snapscript.common.command.MapEnvironment;
import org.snapscript.common.command.ProcessCommand;

public class CommandBuilder {
    private final String directory;
    private final boolean redirect;
    private final boolean wait;

    public CommandBuilder() {
        this(".");
    }

    public CommandBuilder(String directory) {
        this(directory, true);
    }

    public CommandBuilder(String directory, boolean redirect) {
        this(directory, redirect, false);
    }

    public CommandBuilder(String directory, boolean redirect, boolean wait) {
        this.directory = directory;
        this.redirect = redirect;
        this.wait = wait;
    }

    public Callable<Console> create(String source) throws Exception {
        return this.create(source, this.directory);
    }

    public Callable<Console> create(String source, String directory) throws Exception {
        return this.create(source, directory, Collections.EMPTY_MAP);
    }

    public Callable<Console> create(String source, Map<String, String> context) throws Exception {
        return this.create(source, this.directory, context);
    }

    public Callable<Console> create(String source, String directory, Map<String, String> context) throws Exception {
        File path = new File(directory);
        MapEnvironment environment = new MapEnvironment(context);
        ProcessCommand command = new ProcessCommand(source, path, this.redirect, this.wait);
        return new CommandOperation(command, environment);
    }
}

