/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.command;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Iterator;

public class Console
implements Iterable<String> {
    private final LineNumberReader parser;
    private final Reader reader;

    public Console(InputStream source) {
        this.reader = new InputStreamReader(source);
        this.parser = new LineNumberReader(this.reader);
    }

    @Override
    public Iterator<String> iterator() {
        return new LineIterator(this.parser);
    }

    private static class LineIterator
    implements Iterator<String> {
        private LineNumberReader reader;
        private String line;

        public LineIterator(LineNumberReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.line == null) {
                    this.line = this.reader.readLine();
                }
            }
            catch (Exception e) {
                return false;
            }
            return this.line != null;
        }

        @Override
        public String next() {
            try {
                if (this.hasNext()) {
                    String string = this.line;
                    return string;
                }
            }
            finally {
                this.line = null;
            }
            return this.line;
        }
    }
}

