/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.io;

import org.snapscript.common.io.StatementException;
import org.snapscript.common.io.StatementReader;

public abstract class PropertyReader<T>
extends StatementReader<T> {
    protected PropertyReader(String file) {
        super(file);
    }

    @Override
    protected T create(char[] data, int off, int length, int line) {
        int seek = 0;
        while (seek < length) {
            char next;
            if (!this.separator(next = data[off + seek++])) continue;
            String name = this.format(data, off, seek - 1);
            if (seek >= length) {
                throw new StatementException("No value in '" + this.file + "' at line " + line);
            }
            return this.create(name, data, off + seek, length - seek, line);
        }
        throw new StatementException("Error in '" + this.file + "' at line " + line);
    }

    protected String format(char[] data, int off, int length) {
        char next;
        int start;
        int finish = off + length;
        for (start = off; start < finish && this.space(next = data[start]); ++start) {
        }
        while (finish > start && this.space(next = data[finish - 1])) {
            --finish;
        }
        return new String(data, start, finish - start);
    }

    protected boolean separator(char value) {
        return value == '=';
    }

    protected abstract T create(String var1, char[] var2, int var3, int var4, int var5);
}

