/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.io;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.snapscript.common.io.StatementException;
import org.snapscript.common.store.CacheStore;
import org.snapscript.common.store.ClassPathStore;
import org.snapscript.common.store.Store;

public abstract class StatementReader<T>
implements Iterable<T> {
    protected final CacheStore cache;
    protected final List<T> list;
    protected final Store store = new ClassPathStore();
    protected final String file;

    protected StatementReader(String file) {
        this.cache = new CacheStore(this.store);
        this.list = new ArrayList<T>();
        this.file = file;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        if (this.list.isEmpty()) {
            String text = this.cache.getString(this.file);
            if (text == null) {
                throw new StatementException("File '" + this.file + "' not found");
            }
            char[] data = text.toCharArray();
            if (data.length == 0) {
                throw new StatementException("File '" + this.file + "' is empty");
            }
            this.parse(data);
        }
        return this.list.iterator();
    }

    private void parse(char[] data) {
        int count = data.length;
        int write = 0;
        int read = 0;
        int line = 1;
        if (count > 0) {
            char[] copy = new char[data.length];
            block0: while (read < count) {
                char value;
                char next;
                if (this.comment(next = data[read++])) {
                    while (read < count) {
                        if (!this.line(value = data[read++])) continue;
                        ++line;
                        continue block0;
                    }
                    continue;
                }
                if (this.quote(next)) {
                    copy[write++] = next;
                    while (read < count) {
                        if (this.line(value = data[read++])) {
                            ++line;
                        } else if (value == next) {
                            copy[write++] = value;
                            continue block0;
                        }
                        copy[write++] = value;
                    }
                    continue;
                }
                if (this.terminal(next)) {
                    int length = write;
                    if (!this.line(next)) {
                        while (read < count) {
                            char value2;
                            if (this.line(value2 = data[read++])) {
                                ++line;
                                break;
                            }
                            if (this.space(value2)) continue;
                            throw new StatementException("Error in '" + this.file + "' at line " + line);
                        }
                    }
                    write = 0;
                    this.process(copy, 0, length, line);
                    continue;
                }
                if (this.line(next)) {
                    ++line;
                    continue;
                }
                copy[write++] = next;
            }
        }
    }

    private void process(char[] data, int off, int length, int line) {
        char next;
        int start;
        int finish = off + length;
        for (start = off; start < finish && this.space(next = data[start]); ++start) {
        }
        while (finish > start && this.space(next = data[finish - 1])) {
            --finish;
        }
        if (start < finish) {
            T value = this.create(data, start, finish - start, line);
            this.list.add(value);
        }
    }

    protected boolean line(char value) {
        return value == '\n';
    }

    protected boolean comment(char value) {
        return value == '#';
    }

    protected boolean quote(char value) {
        switch (value) {
            case '\"': 
            case '\'': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean space(char value) {
        switch (value) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected boolean terminal(char value) {
        return value == '\n';
    }

    protected abstract T create(char[] var1, int var2, int var3, int var4);
}

