/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.store;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.common.Cache;
import org.snapscript.common.SoftCache;
import org.snapscript.common.store.NotFoundException;
import org.snapscript.common.store.Store;
import org.snapscript.common.store.StoreException;
import org.snapscript.common.store.StoreReader;

public class CacheStore
implements Store {
    private final Cache<String, byte[]> cache;
    private final Set<String> failures;
    private final StoreReader reader;
    private final Store store;

    public CacheStore(Store store) {
        this(store, 200);
    }

    public CacheStore(Store store, int capacity) {
        this(store, capacity, 8192);
    }

    public CacheStore(Store store, int capacity, int read) {
        this.cache = new SoftCache<String, byte[]>(capacity);
        this.failures = new CopyOnWriteArraySet<String>();
        this.reader = new StoreReader(store, read);
        this.store = store;
    }

    public byte[] getBytes(String path) {
        if (!this.failures.contains(path)) {
            byte[] resource = this.cache.fetch(path);
            if (resource == null) {
                try {
                    resource = this.reader.getBytes(path);
                    this.cache.cache(path, resource);
                }
                catch (NotFoundException cause) {
                    this.failures.add(path);
                    throw cause;
                }
            }
            if (resource == null) {
                throw new NotFoundException("Could not find '" + path + "'");
            }
            return resource;
        }
        return null;
    }

    public String getString(String path) {
        byte[] resource = this.getBytes(path);
        try {
            if (resource != null) {
                return new String(resource, "UTF-8");
            }
        }
        catch (Exception e) {
            throw new StoreException("Could not read resource '" + path + "'", e);
        }
        return null;
    }

    @Override
    public InputStream getInputStream(String path) {
        byte[] resource = this.getBytes(path);
        try {
            if (resource != null) {
                return new ByteArrayInputStream(resource);
            }
        }
        catch (Exception e) {
            throw new StoreException("Could not read resource '" + path + "'", e);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(String path) {
        return this.store.getOutputStream(path);
    }
}

