/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.snapscript.common.store.ClassPathStore;
import org.snapscript.common.store.Store;
import org.snapscript.common.store.StoreException;

public class FileStore
implements Store {
    private final ClassPathStore store = new ClassPathStore();
    private final File[] roots;

    public FileStore(File ... roots) {
        this.roots = roots;
    }

    @Override
    public InputStream getInputStream(String path) {
        for (File root : this.roots) {
            File resource = new File(root, path);
            if (!resource.exists()) continue;
            try {
                return new FileInputStream(resource);
            }
            catch (Exception e) {
                throw new StoreException("Could not read resource '" + path + "'", e);
            }
        }
        return this.store.getInputStream(path);
    }

    @Override
    public OutputStream getOutputStream(String path) {
        int n = 0;
        File[] fileArray = this.roots;
        int n2 = fileArray.length;
        if (n < n2) {
            File root = fileArray[n];
            File resource = new File(root, path);
            if (resource.exists()) {
                resource.delete();
            }
            if (!root.exists()) {
                root.mkdirs();
            }
            try {
                return new FileOutputStream(resource);
            }
            catch (Exception e) {
                throw new StoreException("Could not write resource '" + path + "'", e);
            }
        }
        return this.store.getOutputStream(path);
    }
}

