/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.store;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.snapscript.common.store.RemoteLocation;
import org.snapscript.common.store.RemoteResponse;
import org.snapscript.common.store.RemoteStatus;
import org.snapscript.common.store.StoreException;

public class RemoteClient {
    private static final String WRITE_METHOD = "PUT";
    private static final int SUCCESS_CODE = 200;
    private static final int NOT_FOUND_CODE = 404;
    private final RemoteLocation location;
    private final URI root;

    public RemoteClient(URI root) {
        this.location = new RemoteLocation(root);
        this.root = root;
    }

    public RemoteResponse get(String path) {
        try {
            URL address = this.location.createRelative(path);
            URLConnection connection = address.openConnection();
            HttpURLConnection request = (HttpURLConnection)connection;
            int code = request.getResponseCode();
            if (code == 200) {
                return new RemoteResponse(request, RemoteStatus.SUCCESS, path);
            }
            if (code == 404) {
                return new RemoteResponse(request, RemoteStatus.NOT_FOUND, path);
            }
            return new RemoteResponse(request, RemoteStatus.ERROR, path);
        }
        catch (Exception e) {
            throw new StoreException("Could not load resource '" + path + "' from '" + this.root + "'", e);
        }
    }

    public RemoteResponse put(String path) {
        try {
            URL address = this.location.createRelative(path);
            URLConnection connection = address.openConnection();
            HttpURLConnection request = (HttpURLConnection)connection;
            request.setDoOutput(true);
            request.setRequestMethod(WRITE_METHOD);
            request.connect();
            return new RemoteResponse(request, RemoteStatus.SUCCESS, path);
        }
        catch (Exception e) {
            throw new StoreException("Could not write resource '" + path + "' to '" + this.root + "'", e);
        }
    }
}

