/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile;

import java.util.concurrent.Executor;
import org.snapscript.common.store.Store;
import org.snapscript.compile.assemble.ExecutorLinker;
import org.snapscript.compile.assemble.OperationEvaluator;
import org.snapscript.compile.validate.ExecutableValidator;
import org.snapscript.compile.verify.ExecutableVerifier;
import org.snapscript.core.Context;
import org.snapscript.core.ContextValidator;
import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.StoreManager;
import org.snapscript.core.constraint.transform.ConstraintTransformer;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.function.bind.FunctionBinder;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.core.module.ModuleRegistry;
import org.snapscript.core.platform.PlatformProvider;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.type.CacheTypeLoader;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.type.TypeLoader;

public class StoreContext
implements Context {
    private final ExecutableValidator validator;
    private final ConstraintTransformer transformer;
    private final ExpressionEvaluator evaluator;
    private final TraceInterceptor interceptor;
    private final PlatformProvider provider;
    private final ExecutableVerifier verifier;
    private final ConstraintMatcher matcher;
    private final ResourceManager manager;
    private final FunctionIndexer indexer;
    private final FunctionResolver resolver;
    private final TypeExtractor extractor;
    private final ModuleRegistry registry;
    private final FunctionBinder binder;
    private final ErrorHandler handler;
    private final ProxyWrapper wrapper;
    private final PackageLinker linker;
    private final ThreadStack stack = new ThreadStack();
    private final TypeLoader loader;

    public StoreContext(Store store) {
        this(store, null);
    }

    public StoreContext(Store store, Executor executor) {
        this.wrapper = new ProxyWrapper(this);
        this.verifier = new ExecutableVerifier();
        this.interceptor = new TraceInterceptor(this.verifier, this.stack);
        this.manager = new StoreManager(store);
        this.registry = new ModuleRegistry(this, executor);
        this.linker = new ExecutorLinker(this, executor);
        this.loader = new CacheTypeLoader(this.linker, this.registry, this.manager, this.wrapper, this.stack);
        this.matcher = new ConstraintMatcher(this.loader, this.wrapper);
        this.extractor = new TypeExtractor(this.loader);
        this.transformer = new ConstraintTransformer(this.extractor);
        this.handler = new ErrorHandler(this.extractor, this.stack);
        this.indexer = new FunctionIndexer(this.extractor, this.stack);
        this.validator = new ExecutableValidator(this.matcher, this.transformer, this.extractor, this.indexer, this.verifier);
        this.resolver = new FunctionResolver(this.extractor, this.stack, this.indexer);
        this.evaluator = new OperationEvaluator(this, this.verifier, executor);
        this.provider = new PlatformProvider(this.extractor, this.wrapper, this.stack);
        this.binder = new FunctionBinder(this.resolver, this.handler);
    }

    @Override
    public TypeExtractor getExtractor() {
        return this.extractor;
    }

    @Override
    public ThreadStack getStack() {
        return this.stack;
    }

    @Override
    public ProxyWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public ErrorHandler getHandler() {
        return this.handler;
    }

    @Override
    public ContextValidator getValidator() {
        return this.validator;
    }

    @Override
    public ConstraintMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public ConstraintTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public TraceInterceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public ResourceManager getManager() {
        return this.manager;
    }

    @Override
    public ExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public ModuleRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public PlatformProvider getProvider() {
        return this.provider;
    }

    @Override
    public FunctionResolver getResolver() {
        return this.resolver;
    }

    @Override
    public FunctionBinder getBinder() {
        return this.binder;
    }

    @Override
    public TypeLoader getLoader() {
        return this.loader;
    }

    @Override
    public PackageLinker getLinker() {
        return this.linker;
    }
}

