/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile;

import org.snapscript.compile.Compiler;
import org.snapscript.compile.Executable;
import org.snapscript.compile.assemble.Application;
import org.snapscript.core.Context;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;

public class StringCompiler
implements Compiler {
    private final PathConverter converter = new FilePathConverter();
    private final Context context;
    private final String module;

    public StringCompiler(Context context) {
        this(context, "default");
    }

    public StringCompiler(Context context, String module) {
        this.context = context;
        this.module = module;
    }

    @Override
    public Executable compile(String source) throws Exception {
        if (source == null) {
            throw new NullPointerException("No source provided");
        }
        Path path = this.converter.createPath(this.module);
        PackageLinker linker = this.context.getLinker();
        Package library = linker.link(path, source, "script");
        return new Application(this.context, library, this.module);
    }
}

