/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import org.snapscript.compile.Executable;
import org.snapscript.compile.assemble.ApplicationCompiler;
import org.snapscript.compile.assemble.ModelScopeBuilder;
import org.snapscript.core.Context;
import org.snapscript.core.Execution;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.link.Package;
import org.snapscript.core.scope.EmptyModel;
import org.snapscript.core.scope.Model;
import org.snapscript.core.scope.Scope;

public class Application
implements Executable {
    private final ApplicationCompiler compiler;
    private final ModelScopeBuilder builder;
    private final Context context;
    private final String module;
    private final Model empty;

    public Application(Context context, Package library, String module) {
        this.compiler = new ApplicationCompiler(context, library);
        this.builder = new ModelScopeBuilder(context);
        this.empty = new EmptyModel();
        this.context = context;
        this.module = module;
    }

    @Override
    public void execute() throws Exception {
        this.execute(this.empty);
    }

    @Override
    public void execute(Model model) throws Exception {
        this.execute(model, false);
    }

    @Override
    public void execute(Model model, boolean test) throws Exception {
        Scope scope = this.builder.create(model, this.module);
        ErrorHandler handler = this.context.getHandler();
        Execution execution = this.compiler.compile(scope);
        try {
            if (!test) {
                execution.execute(scope);
            }
        }
        catch (Throwable cause) {
            handler.handleExternalError(Reason.THROW, scope, cause);
        }
    }
}

