/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Context;
import org.snapscript.core.ContextValidator;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageDefinition;
import org.snapscript.core.scope.Scope;

public class ApplicationCompiler {
    private final AtomicReference<Execution> cache = new AtomicReference();
    private final Package library;
    private final Context context;

    public ApplicationCompiler(Context context, Package library) {
        this.library = library;
        this.context = context;
    }

    public Execution compile(Scope scope) throws Exception {
        Execution execution = this.cache.get();
        if (execution == null) {
            ContextValidator validator = this.context.getValidator();
            PackageDefinition definition = this.library.create(scope);
            Statement statement = definition.define(scope, null);
            Execution result = statement.compile(scope, null);
            validator.validate(this.context);
            this.cache.set(result);
            return result;
        }
        return execution;
    }
}

