/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.snapscript.common.Cache;
import org.snapscript.common.LeastRecentlyUsedCache;
import org.snapscript.compile.assemble.Assembler;
import org.snapscript.compile.verify.Verifier;
import org.snapscript.core.Evaluation;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;
import org.snapscript.core.scope.Scope;
import org.snapscript.parse.SyntaxCompiler;
import org.snapscript.parse.SyntaxNode;
import org.snapscript.parse.SyntaxParser;

public class EvaluationCompiler {
    private final Cache<String, Evaluation> cache = new LeastRecentlyUsedCache<String, Evaluation>();
    private final PathConverter converter;
    private final SyntaxCompiler compiler = new SyntaxCompiler("grammar.txt");
    private final Assembler assembler;
    private final Verifier verifier;
    private final Executor executor;
    private final int limit;

    public EvaluationCompiler(Assembler assembler, Verifier verifier, Executor executor) {
        this(assembler, verifier, executor, 200);
    }

    public EvaluationCompiler(Assembler assembler, Verifier verifier, Executor executor, int limit) {
        this.converter = new FilePathConverter();
        this.assembler = assembler;
        this.executor = executor;
        this.verifier = verifier;
        this.limit = limit;
    }

    public Evaluation compile(Scope scope, String source, String module) throws Exception {
        Evaluation evaluation = this.cache.fetch(source);
        if (evaluation == null) {
            Executable executable = new Executable(scope, source, module);
            FutureTask<Evaluation> task = new FutureTask<Evaluation>(executable);
            if (this.executor != null) {
                this.executor.execute(task);
            } else {
                task.run();
            }
            return task.get();
        }
        return evaluation;
    }

    private class Executable
    implements Callable<Evaluation> {
        private final String source;
        private final String module;
        private final Scope scope;

        public Executable(Scope scope, String source, String module) {
            this.source = source;
            this.module = module;
            this.scope = scope;
        }

        @Override
        public Evaluation call() throws Exception {
            SyntaxParser parser = EvaluationCompiler.this.compiler.compile();
            SyntaxNode node = parser.parse(this.module, this.source, "expression");
            Path path = EvaluationCompiler.this.converter.createPath(this.module);
            Evaluation evaluation = (Evaluation)EvaluationCompiler.this.assembler.assemble(node, path);
            int length = this.source.length();
            evaluation.define(this.scope);
            evaluation.compile(this.scope, null);
            EvaluationCompiler.this.verifier.verify();
            if (length < EvaluationCompiler.this.limit) {
                EvaluationCompiler.this.cache.cache(this.source, evaluation);
            }
            return evaluation;
        }
    }
}

