/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import java.util.concurrent.Executor;
import org.snapscript.compile.assemble.Assembler;
import org.snapscript.compile.assemble.OperationBuilder;
import org.snapscript.compile.assemble.OperationTraverser;
import org.snapscript.core.Context;
import org.snapscript.core.module.Path;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.parse.SyntaxNode;
import org.snapscript.tree.InstructionResolver;
import org.snapscript.tree.OperationResolver;

public class OperationAssembler
implements Assembler {
    private final OperationTraverser traverser;
    private final OperationResolver resolver;
    private final OperationBuilder builder;
    private final Context context;

    public OperationAssembler(Context context, Executor executor) {
        this(context, executor, "instruction.txt");
    }

    public OperationAssembler(Context context, Executor executor, String file) {
        this.builder = new OperationBuilder(context, executor);
        this.resolver = new InstructionResolver(context, file);
        this.traverser = new OperationTraverser(this.builder, this.resolver);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T assemble(SyntaxNode token, Path path) throws Exception {
        ThreadStack stack = this.context.getStack();
        try {
            Object object = this.traverser.create(token, path);
            return (T)object;
        }
        finally {
            stack.clear();
        }
    }
}

