/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import java.util.concurrent.Executor;
import org.snapscript.compile.assemble.Assembler;
import org.snapscript.compile.assemble.OperationAssembler;
import org.snapscript.core.Context;
import org.snapscript.core.Statement;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.StatementPackage;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;
import org.snapscript.parse.SyntaxCompiler;
import org.snapscript.parse.SyntaxNode;
import org.snapscript.parse.SyntaxParser;

public class PackageBuilder {
    private final SyntaxCompiler compiler = new SyntaxCompiler("grammar.txt");
    private final PathConverter converter;
    private final Assembler assembler;

    public PackageBuilder(Context context, Executor executor) {
        this.assembler = new OperationAssembler(context, executor);
        this.converter = new FilePathConverter();
    }

    public Package create(Path path, String source, String grammar) throws Exception {
        String resource = path.getPath();
        SyntaxParser parser = this.compiler.compile();
        SyntaxNode node = parser.parse(resource, source, grammar);
        Statement statement = (Statement)this.assembler.assemble(node, path);
        String module = this.converter.createModule(resource);
        return new StatementPackage(statement, path, module);
    }
}

