/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.validate;

import org.snapscript.compile.validate.ValidateException;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.property.Property;
import org.snapscript.core.type.Type;

public class PropertyValidator {
    private final String[] ignores;

    public PropertyValidator(ConstraintMatcher matcher) {
        this(matcher, "class", "this", "name", "ordinal", "values");
    }

    public PropertyValidator(ConstraintMatcher matcher, String ... ignores) {
        this.ignores = ignores;
    }

    public void validate(Property property) throws Exception {
        Type source = property.getSource();
        String name = property.getName();
        int matches = 0;
        for (String ignore : this.ignores) {
            if (!ignore.equals(name)) continue;
            ++matches;
        }
        if (matches == 0 && source == null) {
            throw new ValidateException("Property '" + property + "' does not have a type");
        }
    }
}

