/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.common.CopyOnWriteSparseArray;
import org.snapscript.common.SparseArray;
import org.snapscript.core.Entity;

public class EntityCache<V> {
    private final SparseArray<V> array;
    private final Cache<Entity, V> cache;

    public EntityCache() {
        this(10000);
    }

    public EntityCache(int capacity) {
        this.array = new CopyOnWriteSparseArray<V>(capacity);
        this.cache = new CopyOnWriteCache<Entity, V>();
    }

    public V take(Entity type) {
        int order = type.getOrder();
        if (order == 0) {
            return this.cache.take(type);
        }
        return this.array.remove(order);
    }

    public V fetch(Entity type) {
        int order = type.getOrder();
        if (order == 0) {
            return this.cache.fetch(type);
        }
        return this.array.get(order);
    }

    public boolean contains(Entity type) {
        int order = type.getOrder();
        if (order == 0) {
            return this.cache.contains(type);
        }
        return this.array.get(order) != null;
    }

    public void cache(Entity type, V value) {
        int order = type.getOrder();
        if (order == 0) {
            this.cache.cache(type, value);
        }
        this.array.set(order, value);
    }
}

