/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

public enum ModifierType {
    VARIABLE(1, "var", "let"),
    CONSTANT(2, "const"),
    FUNCTION(4, "function", "func"),
    ALIAS(8, "type"),
    CLASS(16, "class"),
    TRAIT(32, "trait"),
    ENUM(64, "enum"),
    MODULE(128, "module"),
    OVERRIDE(256, "override"),
    PRIVATE(512, "private"),
    PUBLIC(1024, "public"),
    PROTECTED(2048, "protected"),
    STATIC(4096, "static"),
    ABSTRACT(8192, "abstract"),
    PROXY(16384, "proxy"),
    ARRAY(32768, "[]"),
    VARARGS(65536, "...");

    public final String[] tokens;
    public final int mask;
    private static final ModifierType[] VALUES;

    private ModifierType(int mask, String ... tokens) {
        this.tokens = tokens;
        this.mask = mask;
    }

    public static boolean isDefault(int modifier) {
        return modifier == -1;
    }

    public static boolean isStatic(int modifier) {
        return modifier >= 0 && (ModifierType.STATIC.mask & modifier) != 0;
    }

    public static boolean isModule(int modifier) {
        return modifier >= 0 && (ModifierType.MODULE.mask & modifier) != 0;
    }

    public static boolean isAlias(int modifier) {
        return modifier >= 0 && (ModifierType.ALIAS.mask & modifier) != 0;
    }

    public static boolean isClass(int modifier) {
        return modifier >= 0 && (ModifierType.CLASS.mask & modifier) != 0;
    }

    public static boolean isTrait(int modifier) {
        return modifier >= 0 && (ModifierType.TRAIT.mask & modifier) != 0;
    }

    public static boolean isEnum(int modifier) {
        return modifier >= 0 && (ModifierType.ENUM.mask & modifier) != 0;
    }

    public static boolean isProxy(int modifier) {
        return modifier >= 0 && (ModifierType.PROXY.mask & modifier) != 0;
    }

    public static boolean isFunction(int modifier) {
        return modifier >= 0 && (ModifierType.FUNCTION.mask & modifier) != 0;
    }

    public static boolean isArray(int modifier) {
        return modifier >= 0 && (ModifierType.ARRAY.mask & modifier) != 0;
    }

    public static boolean isConstant(int modifier) {
        return modifier >= 0 && (ModifierType.CONSTANT.mask & modifier) != 0;
    }

    public static boolean isVariable(int modifier) {
        return modifier >= 0 && (ModifierType.VARIABLE.mask & modifier) != 0;
    }

    public static boolean isOverride(int modifier) {
        return modifier >= 0 && (ModifierType.OVERRIDE.mask & modifier) != 0;
    }

    public static boolean isAbstract(int modifier) {
        return modifier >= 0 && (ModifierType.ABSTRACT.mask & modifier) != 0;
    }

    public static boolean isPublic(int modifier) {
        return modifier >= 0 && (ModifierType.PUBLIC.mask & modifier) != 0;
    }

    public static boolean isPrivate(int modifier) {
        return modifier >= 0 && (ModifierType.PRIVATE.mask & modifier) != 0;
    }

    public static boolean isProtected(int modifier) {
        return modifier >= 0 && (ModifierType.PROTECTED.mask & modifier) != 0;
    }

    public static boolean isVariableArgument(int modifier) {
        return modifier >= 0 && (ModifierType.VARARGS.mask & modifier) != 0;
    }

    public static ModifierType resolveModifier(String token) {
        if (token != null) {
            for (ModifierType modifier : VALUES) {
                for (int i = 0; i < modifier.tokens.length; ++i) {
                    if (!modifier.tokens[i].equals(token)) continue;
                    return modifier;
                }
            }
        }
        return null;
    }

    static {
        VALUES = new ModifierType[]{VARIABLE, CONSTANT, FUNCTION, CLASS, TRAIT, ENUM, MODULE, OVERRIDE, PRIVATE, PUBLIC, PROTECTED, STATIC, ABSTRACT};
    }
}

