/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.Entity;
import org.snapscript.core.ModifierType;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.property.Property;

public class ModifierValidator {
    private static final int CONSTANT_VARIABLE = ModifierType.CONSTANT.mask | ModifierType.VARIABLE.mask;
    private static final int OVERRIDE_STATIC = ModifierType.OVERRIDE.mask | ModifierType.STATIC.mask;
    private static final int ABSTRACT_STATIC = ModifierType.ABSTRACT.mask | ModifierType.STATIC.mask;
    private static final int PUBLIC_PRIVATE = ModifierType.PUBLIC.mask | ModifierType.PRIVATE.mask;

    public void validate(Entity source, Property property, int modifiers) {
        if ((PUBLIC_PRIVATE & modifiers) == PUBLIC_PRIVATE) {
            throw new InternalStateException("Property '" + source + '.' + property + "' is both public and private");
        }
        if ((CONSTANT_VARIABLE & modifiers) == CONSTANT_VARIABLE) {
            throw new InternalStateException("Property '" + source + '.' + property + "' is both variable and constant");
        }
        if ((ModifierType.OVERRIDE.mask & modifiers) == ModifierType.OVERRIDE.mask) {
            throw new InternalStateException("Property '" + source + '.' + property + "' is declared as override");
        }
        if ((ModifierType.ABSTRACT.mask & modifiers) == ModifierType.ABSTRACT.mask) {
            throw new InternalStateException("Property '" + source + '.' + property + "' is declared as abstract");
        }
    }

    public void validate(Entity source, Function function, int modifiers) {
        int type = source.getModifiers();
        if ((PUBLIC_PRIVATE & modifiers) == PUBLIC_PRIVATE) {
            throw new InternalStateException("Function '" + function + "' is both public and private");
        }
        if ((OVERRIDE_STATIC & modifiers) == OVERRIDE_STATIC) {
            throw new InternalStateException("Function '" + function + "' is both static and override");
        }
        if ((ABSTRACT_STATIC & modifiers) == ABSTRACT_STATIC) {
            throw new InternalStateException("Function '" + function + "' is both static and abstract");
        }
        if ((ModifierType.CONSTANT.mask & modifiers) == ModifierType.CONSTANT.mask) {
            throw new InternalStateException("Function '" + function + "' is declared as constant");
        }
        if ((ModifierType.VARIABLE.mask & modifiers) == ModifierType.VARIABLE.mask) {
            throw new InternalStateException("Function '" + function + "' is declared as variable");
        }
        if ((ModifierType.ABSTRACT.mask & modifiers) == ModifierType.ABSTRACT.mask && (ModifierType.ABSTRACT.mask & type) != ModifierType.ABSTRACT.mask) {
            throw new InternalStateException("Function '" + function + "' is abstract but '" + source + "' is not");
        }
    }
}

