/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.error.InternalArgumentException;

public class NameFormatter {
    private static final String[] DIMENSIONS = new String[]{"", "[]", "[][]", "[][][]"};
    private static final String DIMENSION = "[]";

    public String formatFullName(Class type) {
        Class<?> entry = type.getComponentType();
        if (entry != null) {
            return this.formatFullName(entry) + DIMENSION;
        }
        return type.getName();
    }

    public String formatShortName(Class type) {
        Class<?> entry = type.getComponentType();
        if (entry != null) {
            return this.formatShortName(entry) + DIMENSION;
        }
        String name = type.getName();
        int index = name.lastIndexOf(46);
        int length = name.length();
        if (index > 0) {
            return name.substring(index + 1, length);
        }
        return name;
    }

    public String formatShortName(String type) {
        int index = type.lastIndexOf(46);
        int length = type.length();
        if (index > 0) {
            return type.substring(index + 1, length);
        }
        return type;
    }

    public String formatFullName(String module, String name) {
        if (name == null) {
            return module;
        }
        if (module != null) {
            int index = module.lastIndexOf(".");
            char first = module.charAt(index == -1 ? 0 : index + 1);
            if (Character.isUpperCase(first)) {
                return module + '$' + name;
            }
            return module + "." + name;
        }
        return name;
    }

    public String formatArrayName(String type, int size) {
        int limit = DIMENSIONS.length;
        if (size >= DIMENSIONS.length) {
            throw new InternalArgumentException("Maximum of " + limit + " dimensions exceeded");
        }
        return type + DIMENSIONS[size];
    }

    public String formatArrayName(String module, String name, int size) {
        int limit = DIMENSIONS.length;
        if (size >= DIMENSIONS.length) {
            throw new InternalArgumentException("Maximum of " + limit + " dimensions exceeded");
        }
        String bounds = DIMENSIONS[size];
        String type = this.formatFullName(module, name);
        return type + bounds;
    }

    public String formatOuterName(String type) {
        if (type != null) {
            int index = type.lastIndexOf(36);
            if (index > 0) {
                return type.substring(0, index);
            }
            return type;
        }
        return null;
    }

    public String formatOuterName(String module, String name) {
        String parent;
        int length;
        int index;
        if (name != null && (index = name.lastIndexOf(36)) > 0 && (length = (parent = name.substring(0, index)).length()) > 0) {
            return this.formatFullName(module, parent);
        }
        return null;
    }

    public String formatInnerName(String type) {
        if (type != null) {
            String name = this.formatShortName(type);
            int index = name.lastIndexOf(36);
            int length = name.length();
            if (index > 0) {
                return name.substring(index + 1, length);
            }
            return name;
        }
        return null;
    }

    public String formatLocalName(String type) {
        if (type != null) {
            String name = this.formatTopName(type);
            int index = name.lastIndexOf(46);
            int length = name.length();
            if (index > 0) {
                return name.substring(index + 1, length);
            }
            return name;
        }
        return null;
    }

    public String formatTopName(String type) {
        if (type != null) {
            int index = type.indexOf(36);
            if (index > 0) {
                return type.substring(0, index);
            }
            return type;
        }
        return null;
    }

    public String formatTopName(String module, String name) {
        if (name != null) {
            String parent;
            int length;
            int index = name.indexOf(36);
            if (index > 0 && (length = (parent = name.substring(0, index)).length()) > 0) {
                return this.formatFullName(module, parent);
            }
            return this.formatFullName(module, name);
        }
        return null;
    }
}

