/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.array;

import java.lang.reflect.Array;
import java.util.List;
import org.snapscript.core.array.BooleanList;
import org.snapscript.core.array.ByteList;
import org.snapscript.core.array.CharacterList;
import org.snapscript.core.array.DoubleList;
import org.snapscript.core.array.FloatList;
import org.snapscript.core.array.IntegerList;
import org.snapscript.core.array.LongList;
import org.snapscript.core.array.ObjectList;
import org.snapscript.core.array.PrimitiveBooleanList;
import org.snapscript.core.array.PrimitiveByteList;
import org.snapscript.core.array.PrimitiveCharacterList;
import org.snapscript.core.array.PrimitiveDoubleList;
import org.snapscript.core.array.PrimitiveFloatList;
import org.snapscript.core.array.PrimitiveIntegerList;
import org.snapscript.core.array.PrimitiveLongList;
import org.snapscript.core.array.PrimitiveShortList;
import org.snapscript.core.array.ShortList;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class ArrayBuilder {
    public Type convert(Type type) throws Exception {
        Scope scope = type.getScope();
        Module module = scope.getModule();
        return module.getType(List.class);
    }

    public List convert(Object array) throws Exception {
        Class<?> type = array.getClass();
        if (type == byte[].class) {
            return new PrimitiveByteList((byte[])array);
        }
        if (type == int[].class) {
            return new PrimitiveIntegerList((int[])array);
        }
        if (type == long[].class) {
            return new PrimitiveLongList((long[])array);
        }
        if (type == double[].class) {
            return new PrimitiveDoubleList((double[])array);
        }
        if (type == float[].class) {
            return new PrimitiveFloatList((float[])array);
        }
        if (type == short[].class) {
            return new PrimitiveShortList((short[])array);
        }
        if (type == char[].class) {
            return new PrimitiveCharacterList((char[])array);
        }
        if (type == boolean[].class) {
            return new PrimitiveBooleanList((boolean[])array);
        }
        if (type == Byte[].class) {
            return new ByteList((Byte[])array);
        }
        if (type == Integer[].class) {
            return new IntegerList((Integer[])array);
        }
        if (type == Long[].class) {
            return new LongList((Long[])array);
        }
        if (type == Double[].class) {
            return new DoubleList((Double[])array);
        }
        if (type == Float[].class) {
            return new FloatList((Float[])array);
        }
        if (type == Short[].class) {
            return new ShortList((Short[])array);
        }
        if (type == Character[].class) {
            return new CharacterList((Character[])array);
        }
        if (type == Boolean[].class) {
            return new BooleanList((Boolean[])array);
        }
        return new ObjectList((Object[])array, type);
    }

    public Object create(Class type, int size) throws Exception {
        if (type == Byte.TYPE || type == Byte.class) {
            return new byte[size];
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new int[size];
        }
        if (type == Long.TYPE || type == Long.class) {
            return new long[size];
        }
        if (type == Double.TYPE || type == Double.class) {
            return new double[size];
        }
        if (type == Float.TYPE || type == Float.class) {
            return new float[size];
        }
        if (type == Short.TYPE || type == Short.class) {
            return new short[size];
        }
        if (type == Character.TYPE || type == Character.class) {
            return new char[size];
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new boolean[size];
        }
        if (type == null) {
            return new Object[size];
        }
        return Array.newInstance(type, size);
    }

    public Object create(Class type, int first, int second) throws Exception {
        if (type == Byte.TYPE || type == Byte.class) {
            return new byte[first][second];
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new int[first][second];
        }
        if (type == Long.TYPE || type == Long.class) {
            return new long[first][second];
        }
        if (type == Double.TYPE || type == Double.class) {
            return new double[first][second];
        }
        if (type == Float.TYPE || type == Float.class) {
            return new float[first][second];
        }
        if (type == Short.TYPE || type == Short.class) {
            return new short[first][second];
        }
        if (type == Character.TYPE || type == Character.class) {
            return new char[first][second];
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new boolean[first][second];
        }
        if (type == null) {
            return new Object[first][second];
        }
        return Array.newInstance(type, first, second);
    }

    public Object create(Class type, int first, int second, int third) throws Exception {
        if (type == Byte.TYPE || type == Byte.class) {
            return new byte[first][second][third];
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new int[first][second][third];
        }
        if (type == Long.TYPE || type == Long.class) {
            return new long[first][second][third];
        }
        if (type == Double.TYPE || type == Double.class) {
            return new double[first][second][third];
        }
        if (type == Float.TYPE || type == Float.class) {
            return new float[first][second][third];
        }
        if (type == Short.TYPE || type == Short.class) {
            return new short[first][second][third];
        }
        if (type == Character.TYPE || type == Character.class) {
            return new char[first][second][third];
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new boolean[first][second][third];
        }
        if (type == null) {
            return new Object[first][second][third];
        }
        return Array.newInstance(type, first, second, third);
    }
}

