/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.array;

import java.lang.reflect.Array;
import org.snapscript.core.array.ArrayWrapper;

public class ObjectList
extends ArrayWrapper<Object> {
    private final Object[] array;
    private final Class type;
    private final int length;

    public ObjectList(Object[] array, Class type) {
        this.length = array.length;
        this.array = array;
        this.type = type;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public Object set(int index, Object value) {
        Object previous = this.array[index];
        this.array[index] = value;
        return previous;
    }

    @Override
    public Object[] toArray() {
        Object instance = Array.newInstance(this.type, this.length);
        Object[] copy = (Object[])instance;
        for (int i = 0; i < this.length; ++i) {
            copy[i] = this.array[i];
        }
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] copy) {
        Class<?> type = copy.getClass();
        int require = copy.length;
        if (require >= this.length) {
            for (int i = 0; i < this.length; ++i) {
                copy[i] = this.array[i];
            }
        }
        return this.toArray();
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            Object value = this.array[i];
            if (!object.equals(value)) continue;
            return i;
        }
        return -1;
    }
}

