/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.array;

import org.snapscript.core.array.ArrayWrapper;
import org.snapscript.core.error.InternalArgumentException;

public class PrimitiveBooleanList
extends ArrayWrapper<Boolean> {
    private final boolean[] array;
    private final int length;

    public PrimitiveBooleanList(boolean[] array) {
        this.length = array.length;
        this.array = array;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Boolean get(int index) {
        return this.array[index];
    }

    @Override
    public Boolean set(int index, Boolean value) {
        Boolean result = this.array[index];
        this.array[index] = value;
        return result;
    }

    @Override
    public Object[] toArray() {
        Object[] copy = new Boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            copy[i] = this.array[i];
        }
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] copy) {
        Class<?> type = copy.getClass();
        int require = copy.length;
        for (int i = 0; i < this.length && i < require; ++i) {
            Boolean flag = this.array[i];
            Object value = flag;
            if (type == String[].class) {
                value = value.toString();
            } else if (type == Boolean[].class) {
                value = flag;
            } else if (type == Object[].class) {
                value = flag;
            } else {
                throw new InternalArgumentException("Incompatible array type");
            }
            copy[i] = value;
        }
        return copy;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            Boolean value = this.array[i];
            if (!object.equals(value)) continue;
            return i;
        }
        return -1;
    }
}

