/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.array;

import org.snapscript.core.array.ArrayWrapper;
import org.snapscript.core.error.InternalArgumentException;

public class PrimitiveFloatList
extends ArrayWrapper<Object> {
    private final float[] array;
    private final int length;

    public PrimitiveFloatList(float[] array) {
        this.length = array.length;
        this.array = array;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Object get(int index) {
        return Float.valueOf(this.array[index]);
    }

    @Override
    public Object set(int index, Object value) {
        Float previous = Float.valueOf(this.array[index]);
        Class<?> type = value.getClass();
        if (type == String.class) {
            String text = (String)value;
            this.array[index] = Float.parseFloat(text);
        } else {
            Number number = (Number)value;
            this.array[index] = number.floatValue();
        }
        return previous;
    }

    @Override
    public Object[] toArray() {
        Object[] copy = new Float[this.length];
        for (int i = 0; i < this.length; ++i) {
            copy[i] = Float.valueOf(this.array[i]);
        }
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] copy) {
        Class<?> type = copy.getClass();
        int require = copy.length;
        for (int i = 0; i < this.length && i < require; ++i) {
            Float number = Float.valueOf(this.array[i]);
            Object value = number;
            if (type != Float[].class) {
                if (type == Byte[].class) {
                    value = number.byteValue();
                } else if (type == Double[].class) {
                    value = number.doubleValue();
                } else if (type == Integer[].class) {
                    value = number.intValue();
                } else if (type == Long[].class) {
                    value = number.longValue();
                } else if (type == Short[].class) {
                    value = number.shortValue();
                } else if (type == String[].class) {
                    value = number.toString();
                } else if (type == Object[].class) {
                    value = number;
                } else {
                    throw new InternalArgumentException("Incompatible array type");
                }
            }
            copy[i] = value;
        }
        return copy;
    }

    @Override
    public int indexOf(Object object) {
        Class<?> type = object.getClass();
        for (int i = 0; i < this.length; ++i) {
            Float number = Float.valueOf(this.array[i]);
            Object value = number;
            if (type != Float.class) {
                if (type == Integer.class) {
                    value = number.intValue();
                } else if (type == Byte.class) {
                    value = number.byteValue();
                } else if (type == Double.class) {
                    value = number.doubleValue();
                } else if (type == Long.class) {
                    value = number.longValue();
                } else if (type == Short.class) {
                    value = number.shortValue();
                } else if (type == String.class) {
                    value = number.toString();
                } else {
                    throw new InternalArgumentException("Incompatible value type");
                }
            }
            if (!object.equals(value)) continue;
            return i;
        }
        return -1;
    }
}

