/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import java.util.Collections;
import java.util.List;
import org.snapscript.core.Context;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeLoader;

public class ClassConstraint
extends Constraint {
    private final List<Constraint> generics;
    private final Class require;
    private final int modifiers;

    public ClassConstraint(Class require) {
        this(require, Collections.EMPTY_LIST);
    }

    public ClassConstraint(Class require, int modifiers) {
        this(require, Collections.EMPTY_LIST, modifiers);
    }

    public ClassConstraint(Class require, List<Constraint> generics) {
        this(require, generics, 0);
    }

    public ClassConstraint(Class require, List<Constraint> generics, int modifiers) {
        this.modifiers = modifiers;
        this.generics = generics;
        this.require = require;
    }

    @Override
    public Type getType(Scope scope) {
        if (this.require != null) {
            Module module = scope.getModule();
            Context context = module.getContext();
            TypeLoader loader = context.getLoader();
            return loader.loadType(this.require);
        }
        return null;
    }

    @Override
    public List<Constraint> getGenerics(Scope scope) {
        return this.generics;
    }

    @Override
    public boolean isVariable() {
        return !ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isConstant() {
        return ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isClass() {
        return ModifierType.isClass(this.modifiers);
    }

    public String toString() {
        return String.valueOf(this.require);
    }
}

