/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import java.util.Collections;
import java.util.List;
import org.snapscript.core.Context;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeLoader;

public class ClassParameterConstraint
extends Constraint {
    private final List<Constraint> generics;
    private final Class require;
    private final String name;
    private final int modifiers;

    public ClassParameterConstraint(Class require, String name) {
        this(require, Collections.EMPTY_LIST, name);
    }

    public ClassParameterConstraint(Class require, String name, int modifiers) {
        this(require, Collections.EMPTY_LIST, name, modifiers);
    }

    public ClassParameterConstraint(Class require, List<Constraint> generics, String name) {
        this(require, generics, name, 0);
    }

    public ClassParameterConstraint(Class require, List<Constraint> generics, String name, int modifiers) {
        this.modifiers = modifiers;
        this.generics = generics;
        this.require = require;
        this.name = name;
    }

    @Override
    public Type getType(Scope scope) {
        if (this.require != null) {
            Module module = scope.getModule();
            Context context = module.getContext();
            TypeLoader loader = context.getLoader();
            return loader.loadType(this.require);
        }
        return null;
    }

    @Override
    public List<Constraint> getGenerics(Scope scope) {
        return this.generics;
    }

    @Override
    public String getName(Scope scope) {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        return !ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isConstant() {
        return ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isClass() {
        return ModifierType.isClass(this.modifiers);
    }

    public String toString() {
        return String.valueOf(this.require);
    }
}

