/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.common.Progress;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Phase;
import org.snapscript.core.type.Type;

public class CompileConstraint
extends Constraint {
    private final AtomicBoolean defined = new AtomicBoolean();
    private final Constraint constraint;
    private final long duration;

    public CompileConstraint(Constraint constraint) {
        this(constraint, 10000L);
    }

    public CompileConstraint(Constraint constraint, long duration) {
        this.constraint = constraint;
        this.duration = duration;
    }

    @Override
    public String getName(Scope scope) {
        return this.constraint.getName(scope);
    }

    @Override
    public List<String> getImports(Scope scope) {
        return this.constraint.getImports(scope);
    }

    @Override
    public List<Constraint> getGenerics(Scope scope) {
        if (!this.defined.get()) {
            Type result = this.constraint.getType(scope);
            Progress<Phase> progress = result.getProgress();
            if (!progress.wait(Phase.DEFINE, this.duration)) {
                throw new InternalStateException("Type '" + result + "' not defined");
            }
            this.defined.set(true);
        }
        return this.constraint.getGenerics(scope);
    }

    @Override
    public Type getType(Scope scope) {
        if (!this.defined.get()) {
            Type result = this.constraint.getType(scope);
            Progress<Phase> progress = result.getProgress();
            if (!progress.wait(Phase.DEFINE, this.duration)) {
                throw new InternalStateException("Type '" + result + "' not defined");
            }
            this.defined.set(true);
        }
        return this.constraint.getType(scope);
    }

    public String toString() {
        return String.valueOf(this.constraint);
    }
}

