/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import java.util.List;
import org.snapscript.core.Entity;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class ConstraintDescription {
    private final Constraint constraint;
    private final Entity entity;

    public ConstraintDescription(Constraint constraint, Entity entity) {
        this.constraint = constraint;
        this.entity = entity;
    }

    public String getDescription() {
        return this.getDescription(this.constraint);
    }

    private String getDescription(Constraint constraint) {
        Scope scope;
        Type type;
        StringBuilder builder = new StringBuilder();
        if (constraint != null && this.entity != null && (type = constraint.getType(scope = this.entity.getScope())) != null) {
            List<Constraint> generics = constraint.getGenerics(scope);
            int length = generics.size();
            builder.append(type);
            if (length > 0) {
                builder.append("<");
                for (int i = 0; i < length; ++i) {
                    Constraint generic = generics.get(i);
                    String entry = this.getDescription(generic);
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(entry);
                }
                builder.append(">");
            }
            return builder.toString();
        }
        return "?";
    }

    public String toString() {
        return this.getDescription();
    }
}

