/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.TypeParameterConstraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;

public class ConstraintMapper {
    public Constraint map(Scope scope, String name) {
        State state = scope.getState();
        Constraint constraint = state.getConstraint(name);
        if (constraint == null) {
            return new TypeParameterConstraint(null, name);
        }
        return constraint;
    }

    public Constraint map(Scope scope, Constraint constraint) {
        Type type = constraint.getType(scope);
        if (type != null) {
            String name = constraint.getName(scope);
            Class real = type.getType();
            if (real == Object.class) {
                return new TypeParameterConstraint(null, name);
            }
            if (real == Void.TYPE) {
                return new TypeParameterConstraint(null, name);
            }
        }
        return constraint;
    }

    public List<Constraint> map(Scope scope, List<Constraint> constraints) {
        int count = constraints.size();
        if (count > 0) {
            ArrayList<Constraint> matches = new ArrayList<Constraint>(count);
            for (Constraint constraint : constraints) {
                Constraint match = this.map(scope, constraint);
                matches.add(match);
            }
            return matches;
        }
        return constraints;
    }
}

