/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.ConstraintDescription;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class StaticConstraint
extends Constraint {
    private final ConstraintDescription description;
    private final Type type;
    private final int modifiers;

    public StaticConstraint(Type type) {
        this(type, 0);
    }

    public StaticConstraint(Type type, int modifiers) {
        this.description = new ConstraintDescription(this, type);
        this.modifiers = modifiers;
        this.type = type;
    }

    @Override
    public Type getType(Scope scope) {
        return this.type;
    }

    @Override
    public boolean isVariable() {
        return !ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isConstant() {
        return ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isClass() {
        return ModifierType.isClass(this.modifiers);
    }

    public String toString() {
        return this.description.toString();
    }
}

