/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.ConstraintDescription;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class StaticParameterConstraint
extends Constraint {
    private final ConstraintDescription description;
    private final String name;
    private final Type type;
    private final int modifiers;

    public StaticParameterConstraint(Type type, String name) {
        this(type, name, 0);
    }

    public StaticParameterConstraint(Type type, String name, int modifiers) {
        this.description = new ConstraintDescription(this, type);
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
    }

    @Override
    public Type getType(Scope scope) {
        return this.type;
    }

    @Override
    public String getName(Scope scope) {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        return !ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isConstant() {
        return ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isClass() {
        return ModifierType.isClass(this.modifiers);
    }

    public String toString() {
        return this.description.toString();
    }
}

