/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint;

import java.util.Collections;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.ConstraintDescription;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class TypeParameterConstraint
extends Constraint {
    private final ConstraintDescription description;
    private final List<Constraint> generics;
    private final String name;
    private final Type type;
    private final int modifiers;

    public TypeParameterConstraint(Type type, String name) {
        this(type, Collections.EMPTY_LIST, name);
    }

    public TypeParameterConstraint(Type type, String name, int modifiers) {
        this(type, Collections.EMPTY_LIST, name, modifiers);
    }

    public TypeParameterConstraint(Type type, List<Constraint> generics, String name) {
        this(type, generics, name, 0);
    }

    public TypeParameterConstraint(Type type, List<Constraint> generics, String name, int modifiers) {
        this.description = new ConstraintDescription(this, type);
        this.modifiers = modifiers;
        this.generics = generics;
        this.type = type;
        this.name = name;
    }

    @Override
    public List<Constraint> getGenerics(Scope scope) {
        return this.generics;
    }

    @Override
    public Type getType(Scope scope) {
        return this.type;
    }

    @Override
    public String getName(Scope scope) {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        return !ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isConstant() {
        return ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isClass() {
        return ModifierType.isClass(this.modifiers);
    }

    public String toString() {
        return this.description.toString();
    }
}

