/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint.transform;

import java.util.HashMap;
import java.util.List;
import org.snapscript.core.EntityCache;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.transform.ConstraintIndex;
import org.snapscript.core.constraint.transform.EmptyIndex;
import org.snapscript.core.constraint.transform.PositionIndex;
import org.snapscript.core.constraint.transform.TypeSource;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class ConstraintIndexBuilder {
    private final EntityCache<ConstraintIndex> indexes = new EntityCache();

    public ConstraintIndex index(Type type) {
        ConstraintIndex index = this.indexes.fetch(type);
        if (index == null) {
            index = this.create(type);
            this.indexes.cache(type, index);
        }
        return index;
    }

    private ConstraintIndex create(Type type) {
        Scope scope = type.getScope();
        List<Constraint> generics = type.getGenerics();
        int count = generics.size();
        if (count > 0) {
            HashMap<String, Integer> positions = new HashMap<String, Integer>();
            TypeSource source = new TypeSource(type);
            for (int i = 0; i < count; ++i) {
                Constraint constraint = generics.get(i);
                String name = constraint.getName(scope);
                if (name == null) continue;
                positions.put(name, i);
            }
            return new PositionIndex(source, positions);
        }
        return new EmptyIndex();
    }
}

