/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint.transform;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.common.Cache;
import org.snapscript.core.EntityTree;
import org.snapscript.core.attribute.Attribute;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.TypeConstraint;
import org.snapscript.core.constraint.transform.AttributeTransform;
import org.snapscript.core.constraint.transform.ChainTransform;
import org.snapscript.core.constraint.transform.ConstraintIndex;
import org.snapscript.core.constraint.transform.ConstraintIndexBuilder;
import org.snapscript.core.constraint.transform.ConstraintTransform;
import org.snapscript.core.constraint.transform.GenericParameterTransform;
import org.snapscript.core.constraint.transform.GenericTransform;
import org.snapscript.core.constraint.transform.IdentityTransform;
import org.snapscript.core.constraint.transform.LocalTransform;
import org.snapscript.core.constraint.transform.StaticParameterTransform;
import org.snapscript.core.constraint.transform.StaticTransform;
import org.snapscript.core.constraint.transform.TypeTransform;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class ConstraintTransformer {
    private final EntityTree<Integer, ConstraintTransform> tree = new EntityTree();
    private final ConstraintIndexBuilder indexer = new ConstraintIndexBuilder();
    private final TypeExtractor extractor;

    public ConstraintTransformer(TypeExtractor extractor) {
        this.extractor = extractor;
    }

    public ConstraintTransform transform(Type constraint, Attribute attribute) {
        Type require = attribute.getSource();
        List<Constraint> generics = attribute.getGenerics();
        int count = generics.size();
        if (require == null || constraint == null) {
            return new LocalTransform(attribute);
        }
        ConstraintTransform transform = this.transform(constraint, require);
        if (count > 0) {
            return new AttributeTransform(transform, attribute);
        }
        return transform;
    }

    public ConstraintTransform transform(Type constraint, Type require) {
        int index = require.getOrder();
        Cache<Integer, ConstraintTransform> cache = this.tree.get(constraint);
        ConstraintTransform transform = cache.fetch(index);
        if (transform == null) {
            transform = this.resolve(constraint, require);
            cache.cache(index, transform);
        }
        return transform;
    }

    private ConstraintTransform resolve(Type constraint, Type require) {
        if (constraint == require) {
            ConstraintIndex index = this.indexer.index(require);
            if (index == null) {
                throw new InternalStateException("Type '" + require + "' count not be indexed");
            }
            return new IdentityTransform(index);
        }
        Type entry = constraint.getEntry();
        if (entry != null) {
            return this.resolveArray(constraint, require);
        }
        return this.resolveType(constraint, require);
    }

    private ConstraintTransform resolveArray(Type constraint, Type require) {
        Class actual = require.getType();
        Type entry = constraint.getEntry();
        Constraint element = Constraint.getConstraint(entry);
        if (Iterable.class.isAssignableFrom(actual)) {
            return this.resolveArray(element, require);
        }
        throw new InternalStateException("Type '" + require + "' is not compatible with an array");
    }

    private ConstraintTransform resolveArray(Constraint constraint, Type require) {
        ConstraintIndex index = this.indexer.index(require);
        List<Constraint> constraints = require.getGenerics();
        if (!constraints.isEmpty()) {
            ArrayList<Constraint> generics = new ArrayList<Constraint>();
            TypeConstraint result = new TypeConstraint(require, generics);
            generics.add(constraint);
            return new StaticTransform(result, index);
        }
        return new TypeTransform(require);
    }

    private ConstraintTransform resolveType(Type constraint, Type require) {
        List<Constraint> constraints = require.getGenerics();
        if (!constraints.isEmpty()) {
            List<Constraint> path = this.extractor.getTypes(constraint, require);
            Constraint original = Constraint.getConstraint(constraint);
            Scope scope = constraint.getScope();
            int count = path.size();
            if (count <= 0) {
                throw new InternalStateException("Type '" + require + "' not in hierarchy of '" + constraint + "'");
            }
            ConstraintTransform[] transforms = new ConstraintTransform[count];
            for (int i = 0; i < count; ++i) {
                Constraint base = path.get(i);
                Type actual = base.getType(scope);
                transforms[i] = this.resolveType(original, actual);
                original = base;
            }
            return new ChainTransform(transforms);
        }
        return new TypeTransform(require);
    }

    private ConstraintTransform resolveType(Constraint constraint, Type require) {
        Scope scope = require.getScope();
        Type actual = constraint.getType(scope);
        List<Constraint> hierarchy = actual.getTypes();
        for (Constraint base : hierarchy) {
            Type type = base.getType(scope);
            if (type != require) continue;
            return this.resolveType(constraint, base, type);
        }
        throw new InternalStateException("Type '" + require + "' not in hierarchy of '" + actual + "'");
    }

    private ConstraintTransform resolveType(Constraint constraint, Constraint require, Type destination) {
        Scope scope = destination.getScope();
        Type origin = constraint.getType(scope);
        ConstraintIndex originIndex = this.indexer.index(origin);
        ConstraintIndex requireIndex = this.indexer.index(destination);
        List<Constraint> generics = require.getGenerics(scope);
        int count = generics.size();
        if (count > 0) {
            ConstraintTransform[] transforms = new ConstraintTransform[count];
            for (int i = 0; i < count; ++i) {
                Constraint generic = generics.get(i);
                Constraint parameter = originIndex.update(scope, constraint, generic);
                transforms[i] = parameter == generic ? new StaticParameterTransform(generic) : new GenericParameterTransform(originIndex, generic, origin);
            }
            return new GenericTransform(destination, requireIndex, transforms);
        }
        return new StaticTransform(require, requireIndex);
    }
}

